function out = robustcov(data) ;
% function out = robustcov(data) ;
%
% Robust covariance matrix of the columns of data.  The covariance matrix is
%  robust in the sense that missing data (NaNs) are completely disregarded when
%  computing the variances and covariances.
% Note that robustcov divides by N rather than by N-1 when computing the covariances.
%
% Written by Eric Swanson, 10/06.

[N,k] = size(data) ;

stddata = data - repmat(robustmean(data),N,1) ;

% Find and remove NaN's from the data:
good = ~isnan(data) ;
stddata(~good) = 0 ;

out = stddata'*stddata ./ (good'*double(good)) ; % note: can't multiply 2 logicals
